/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.util.ImageCanvas;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.Stack;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class Wizard {
    private TextBundle textBundle = UiBundle.getInstance();
    private Shell parent;
    private Shell dialog;
    private Image logo;
    private String title;
    private Stack<WizardPane> wizardPanes = new Stack();
    private boolean wizardCompleted;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Composite contentPane;
    private ImageCanvas imageCanvas;

    public Wizard(Shell parent, Image logo, String title) {
        this.parent = parent;
        this.logo = logo;
        this.title = title;
    }

    private void createDialog() {
        this.dialog = new Shell(this.parent, 67680);
        this.dialog.setText(this.title);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.dialog.setLayout(layout);
        RowData rowData = new RowData();
        rowData.width = this.logo.getImageData().width;
        rowData.height = this.logo.getImageData().height;
        this.imageCanvas = new ImageCanvas(this.dialog, 2048, this.logo, rowData);
        rowData = new RowData();
        rowData.width = this.logo.getImageData().width;
        this.contentPane = new Composite(this.dialog, 2048);
        this.contentPane.setLayoutData(rowData);
        this.contentPane.setLayout(new FillLayout());
        Composite composite = new Composite(this.dialog, 0);
        composite.setLayoutData(rowData);
        composite.setLayout(new FillLayout(256));
        Button button = new Button(composite, 8);
        button.setText(this.textBundle.get("CancelButton"));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Wizard.this.setWizardCompleted(false);
                Wizard.this.getDialog().close();
            }
        });
        this.backButton = new Button(composite, 8);
        this.backButton.setEnabled(false);
        this.backButton.setText(this.textBundle.get("BackButton"));
        this.backButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                WizardPane current = Wizard.this.getWizardPanes().pop();
                WizardPane previous = Wizard.this.getWizardPanes().peek();
                Wizard.this.getBackButton().setEnabled(Wizard.this.getWizardPanes().size() > 1);
                current.dispose();
                previous.open();
                Wizard.this.getDialog().pack();
            }
        });
        this.nextButton = new Button(composite, 8);
        this.nextButton.setText(this.textBundle.get("NextButton"));
        this.nextButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                WizardPane current = Wizard.this.getWizardPanes().peek();
                WizardPane next = current.getNextPane();
                Wizard.this.getWizardPanes().add(next);
                Wizard.this.getBackButton().setEnabled(Wizard.this.getWizardPanes().size() > 1);
                current.dispose();
                next.open();
                Wizard.this.getDialog().pack();
            }
        });
        this.finishButton = new Button(composite, 8);
        this.finishButton.setEnabled(false);
        this.finishButton.setText(this.textBundle.get("FinishButton"));
        this.finishButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Wizard.this.setWizardCompleted(true);
                Wizard.this.getDialog().close();
            }
        });
        WizardPane wizardPane = this.createInitialWizardPane();
        this.wizardPanes.add(wizardPane);
        wizardPane.open();
        this.dialog.pack();
    }

    public abstract WizardPane createInitialWizardPane();

    public void open() {
        this.createDialog();
        SwtUtil.center(this.parent, this.dialog);
        this.dialog.open();
        Display display = this.dialog.getDisplay();
        while (!this.dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void dispose() {
        while (!this.wizardPanes.empty()) {
            WizardPane pane = this.wizardPanes.pop();
            pane.dispose();
            Object var1_1 = null;
        }
        this.imageCanvas.dispose();
        this.dialog.dispose();
        this.backButton.dispose();
        this.nextButton.dispose();
        this.finishButton.dispose();
        this.contentPane.dispose();
    }

    public boolean isWizardCompleted() {
        return this.wizardCompleted;
    }

    public void enableNextButton(boolean state) {
        this.nextButton.setEnabled(state);
        if (!this.finishButton.isEnabled()) {
            this.dialog.setDefaultButton(this.nextButton);
        }
    }

    public void enableFinishButton(boolean state) {
        this.finishButton.setEnabled(state);
        this.dialog.setDefaultButton(this.finishButton);
    }

    protected Composite getContentPane() {
        return this.contentPane;
    }

    public Shell getDialog() {
        return this.dialog;
    }

    protected Button getBackButton() {
        return this.backButton;
    }

    protected Stack<WizardPane> getWizardPanes() {
        return this.wizardPanes;
    }

    protected void setWizardCompleted(boolean wizardCompleted) {
        this.wizardCompleted = wizardCompleted;
    }
}

